/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.spectrelib;

import com.illusivesoulworks.spectrelib.SpectreConstants;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;

public class EntrypointUtils {
    public static <T> void invokeEntrypoints(String key, Class<T> type, Consumer<? super T> invoker) {
        RuntimeException exception = null;
        List entrypoints = FabricLoader.getInstance().getEntrypointContainers(key, type);
        SpectreConstants.LOG.debug("Iterating over entrypoint {}", (Object)key);
        for (EntrypointContainer container : entrypoints) {
            try {
                invoker.accept(container.getEntrypoint());
            }
            catch (Throwable t) {
                exception = EntrypointUtils.gatherExceptions(t, exception, exc -> new RuntimeException(String.format("Could not execute entrypoint stage '%s' due to errors, provided by '%s'!", key, container.getProvider().getMetadata().getId()), (Throwable)exc));
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static <T extends Throwable> T gatherExceptions(Throwable exc, T prev, Function<Throwable, T> mainExcFactory) {
        exc = EntrypointUtils.unwrap(exc);
        if (prev == null) {
            return (T)((Throwable)mainExcFactory.apply(exc));
        }
        if (exc != prev) {
            for (Throwable t : prev.getSuppressed()) {
                if (!exc.equals(t)) continue;
                return prev;
            }
            prev.addSuppressed(exc);
        }
        return prev;
    }

    private static Throwable unwrap(Throwable exc) {
        Throwable ret;
        if ((exc instanceof UncheckedIOException || exc instanceof ExecutionException || exc instanceof CompletionException) && (ret = exc.getCause()) != null) {
            return EntrypointUtils.unwrap(ret);
        }
        return exc;
    }
}

